/*

    Example: Functional ActionScript — Part II
    
    Author:
    Daniel Gasienica
    daniel@gasienica.ch
    http://gasi.ch/
    
    
    Originally published on
	http://gasi.ch/blog/functional-actionscript-part-2/
    
    Released under the
    Creative Commons Attribution-Share Alike License
    http://creativecommons.org/licenses/by-sa/3.0/
    
*/
package
{
	import flash.display.Sprite;
	
	
	public class FunctionalActionScript2 extends Sprite
	{
		private var list : Array = [ 1, 2, 3, 4, 5, 6, 7, 8, 9 ]
		
		
		// Constructor
		public function FunctionalActionScript2()
		{			
			// every
			trace( "--- every ------------------------------" )
			trace( "Are all numbers even?:", list.every( wrap( even ) ) )
			
			// some
			trace( "\n--- some -------------------------------" )
			trace( "Are some numbers odd?:", list.some( wrap( odd ) ) )
			
			// filter
			trace( "\n--- filter -----------------------------" )
			trace( 			 "Odd numbers:", list.filter( wrap( odd ) ) )
			trace( 			"Even numbers:", list.filter( wrap( even ) ) )
			
			// map
			trace( "\n--- map --------------------------------" )
			trace( 				 "Squares:", list.map( wrap( square ) ) )
			trace( 			"Square roots:", list.map( wrap( squareRoot ) ) )
			
			// forEach
			trace( "\n--- forEach ---------------------------" )
			trace( "Say «Hello» to all numbers!" )
			trace( "---------------------------------------" )
				   list.forEach( sayHello )			
			
			// higher order functions
			trace( "\n--- higher order functions ------------" )
			trace( 				  "Double:", list.map( wrap( double ) ) )
			trace( 				  "Triple:", list.map( wrap( triple ) ) )
			trace( 			   "Quadruple:", list.map( wrap( multiply( 4 ) ) ) )
			
			
			// rendez-vous
			trace( "\n--- rendez-vous ------------" )
			if( list.some( wrap( odd ) ) )
			{
				list.filter( wrap( even ) )
				       .map( wrap( square ) )
				          .forEach( sayHello )
			}
			
		}
		
		
		// test functions for every, some & filter		
		private function even( x : int ) : Boolean
		{
			return x % 2 == 0
		}
		
		private function odd( x : int ) : Boolean
		{
			return !even( x )
		}

		// functions for map
		private function square( x : Number ) : Number
		{
			return x * x
		}

		private function squareRoot( x : int ) : Number
		{
			return Math.sqrt( x )
		}
		
		
		// function for forEach
		private function sayHello( element : *,
								   index : int,
								   array : Array ) : void
		{
			trace( "Hello, Number", element )
		}

		// at this point it looks ok…
		private function double( x : Number ) : Number
		{
			return x * 2
		}

		// …but at this point, it begins to smell.
		private function triple( x : Number ) : Number
		{
			return x * 3
		}

		// better: higher order equivalent
		private function multiply( multiplicator : Number ) : Function
		{
			return function( x : Number ) : Number { return x * multiplicator }
		}

		
		
		/* 
			a beautiful example of a higher order function that takes a function
			as argument and then constructs and returns a new function:
			
			wrapper to make a function's signature conform to that of
			a valid callback which looks like this, e.g. for the filter function
			
				function callback(item:*, index:int, array:Array):Boolean;
			
			http://livedocs.adobe.com/flex/3/langref/Array.html#filter()
		*/
		private function wrap( f : Function ) : Function
		{
			return(
					function( x : *, index : int, array : Array ) : *
					{
						return f( x )
					}
				)
		}
	}
}