/*

	Example: Zooming in Flash
	
	Author:
	Daniel Gasienica
	daniel@gasienica.ch
	http://gasi.ch/
	
	
	Originally published on
	http://gasi.ch/blog/2008/02/05/zooming-in-flash-flex/
	
	Released under the
	Creative Commons Attribution-Share Alike License
	http://creativecommons.org/licenses/by-sa/3.0/
	
*/
package
{
	import com.adobe.viewsource.ViewSource;
	
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	
	
	[SWF(width="450", height="330", frameRate="60", backgroundColor="#333333")]
	public class ZoomingExample extends Sprite
	{
		private var canvas : ZoomCanvas
		
		public function ZoomingExample()
		{
			// configure stage
			stage.scaleMode = StageScaleMode.NO_SCALE
			stage.align = StageAlign.TOP_LEFT
			
			// enable view source
			ViewSource.addMenuItem( this, "source/index.html" )
			
			// create canvas
			canvas = new ZoomCanvas()
			
			// center canvas
			canvas.x = ( stage.stageWidth - canvas.width ) / 2
			canvas.y = ( stage.stageHeight - canvas.height ) / 2
			
			// add canvas to the display list
			addChild( canvas )
		}
	}
}